/*------------------------------------------------------------------------------*
 * File Name: ExtractWksDataDlg													*
 * Creation : Sim 04-13-2009													*
 * Purpose: OriginC Source H file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 06-19-2009 QA80-13808 NOT_SWITCH_INPUT_WHEN_ACTIVE_SHEET_CHANGED			*
 * Sim 06-19-2009 QA80-4584 UPDATE_OK_AND_APPLY_BUTTON_STATUS_FOR_AUTO_UPDATE_SUPPORT
 * Sim 06-23-2009 QA81-13345 REFIX_UPDATE_ROW_SEL_AFTER_COL_VALUE_CHANGE		*
 * Sophy 8/7/2009 v8.1088 EXTRACT_WKS_DATA_SAVE_RECALCULATE_MODE_TO_SOURCE_SHEET*
 *	Kyle 02/22/2010 QA80-15100-P2 PASS_THE_CURRENT_COLUMN_DISPLAY_TO_TIME_LT_FUNCTION
 *	Folger 10/15/2010 ORG-1258 ADD_SELECT_OPTION_IN_WORKSHEET_QUERY				*
 *------------------------------------------------------------------------------*/
 
#ifndef EXTRACT_WKS_DATA_DLG_H
#define EXTRACT_WKS_DATA_DLG_H

enum {
	EXTRACT_CHECK_ALL = COL_PROPERTIES_TOTAL + 1,
	EXTRACT_UNCHECK_ALL
};

class ColumnListMenu : public Menu
{
public:
	ColumnListMenu(vector<int> vnCols, vector<bool> vbCheck, bool bEnableExtract = true)
	{
		bool bExtractExisting = false;
		bool bExtractChecked = false;
		for(int ii = 0; ii < vnCols.GetSize(); ii++)
		{
			string strItem;
			switch(vnCols[ii])
			{
			case COL_CHECK_BOX:
				strItem = _L("Extract");
				bExtractExisting = true;
				bExtractChecked = vbCheck[ii];

				break;		
			//case COL_PROPERTIES_SHORT_NAME:
				//strItem = "Short Name";		break;
			//case COL_PROPERTIES_LONG_NAME:
				//strItem = "Name";		break;
			//case COL_PROPERTIES_UNIT:
				//strItem = "Unit";			break;
			//case COL_PROPERTIES_COMMENT:
				//strItem = "Comment";		break;
			//case COL_PROPERTIES_FORMULA:
				//strItem = "Formula";		break;
			//case COL_PROPERTIES_COLUMN_WIDTH:
				//strItem = "Width";			break;
			case COL_PROPERTIES_PLOT_DESIGNATION:
				strItem = _L("Type");	break;
			case COL_PROPERTIES_FORMAT:
				strItem = _L("Format");			break;
			//case COL_PROPERTIES_DISPLAY:
				//strItem = "Display";		break;
			//case COL_PROPERTIES_NUMERIC:
				//strItem = "Numeric";		break;
			//case COL_PROPERTIES_DIGITS:
				//strItem = "Digits";			break;
			//case COL_PROPERTIES_INTERNAL_DATA:
				//strItem = "Internal Data";	break;
			case COL_PROPERTIES_FIRST_VALUE:
				strItem = _L("1st Value");		break;
			default:
				continue;				
			}
			
			Add(strItem, vnCols[ii], vbCheck[ii] ? MF_CHECKED : MF_UNCHECKED);
		}
		
		if( bExtractExisting )
		{
			Add(NULL, 0, MF_SEPARATOR);	
			
			//int  nFlags = bExtractChecked ? MF_ENABLED : (MF_DISABLED | MF_GRAYED);
			int  nFlags = ( bExtractChecked && bEnableExtract ) ? MF_ENABLED : (MF_DISABLED | MF_GRAYED);
			Add(_L("check all Extract"), EXTRACT_CHECK_ALL, nFlags);
			Add(_L("uncheck all Extract"), EXTRACT_UNCHECK_ALL, nFlags);
		}
	}
};

#define STR_EXTRACT_WKS_DATA_FAVORITES_SECTION	"ExtWksData User Favorites"			///Kyle 12/18/2008 QA80-12790-P2 v8.0988 ADD_POPUP_TO_SHOW_FUNCTIONS_IN_EXTRACT_WKS_DATA_DIALOG_MENU

class ExtWksDataMenu : public Menu
{
public:
	ExtWksDataMenu(HMENU &hMenu) : Menu(hMenu)
	{
		m_pConditionSysSample = new ConditionSysSample(hMenu);
		ASSERT(m_pConditionSysSample);
		m_pConditionSysSample->Load();
		
		m_pConditionUserDefinedMenu = new ConditionUserDefined(hMenu);
		ASSERT(m_pConditionUserDefinedMenu);
		m_pConditionUserDefinedMenu->Load();

		m_pConditionRecentListMenu = new ConditionRecentListMenu(hMenu);
		ASSERT(m_pConditionRecentListMenu);
		m_pConditionRecentListMenu->Load();
	
		vector<uint> vnCategoryIDs = {	IDC_FUNCTION_MENU_MATH, IDC_FUNCTION_MENU_STATS, 
										IDC_FUNCTION_MENU_DATE_TIME, IDC_FUNCTION_MENU_TEXT, 
										IDC_FUNCTION_MENU_USER_DEFINED, IDC_FUNCTION_MENU_VARIABLE_CONSTANT,
										IDC_FUNCTION_MENU_MISCELLANEOUS};
		m_pWksFunctionsMenu = new WksFunctionsMenu(hMenu, STR_EXTRACT_WKS_DATA_FAVORITES_SECTION, vnCategoryIDs);
		ASSERT(m_pWksFunctionsMenu);
		m_pWksFunctionsMenu->Construct();

		//m_pFunctionsFavoriteMenu = new FunctionsFavoriteMenu_(hMenu, STR_EXTRACT_WKS_DATA_FAVORITES_SECTION);
		//ASSERT(m_pFunctionsFavoriteMenu);
	}
	
public:
	ConditionSysSample		*m_pConditionSysSample;
	ConditionUserDefined	*m_pConditionUserDefinedMenu;
	ConditionRecentListMenu	*m_pConditionRecentListMenu;

	WksFunctionsMenu		*m_pWksFunctionsMenu;
	//FunctionsFavoriteMenu_	*m_pFunctionsFavoriteMenu;
};

class ExtractDataDlg : public ResizeDialog
{
public:
	ExtractDataDlg() : ResizeDialog(IDD_EXTRACT_DATA_DLG, "ODlg8")
	{
		m_bShowColList = true;
		//m_bReady = true;
		///---Sim 06-19-2009 QA80-4584 UPDATE_OK_AND_APPLY_BUTTON_STATUS_FOR_AUTO_UPDATE_SUPPORT
		//m_nAutoUpdateMode = DEFAULT_AU_MODE;
		//m_nAutoUpdateMode = AU_NONE;///Sophy 8/7/2009 v8.1088 EXTRACT_WKS_DATA_SAVE_RECALCULATE_MODE_TO_SOURCE_SHEET
		///---END QA80-4584 UPDATE_OK_AND_APPLY_BUTTON_STATUS_FOR_AUTO_UPDATE_SUPPORT
	}
	~ExtractDataDlg()
	{
	}

	//int DoModalEx(TreeNode& trSetting, HWND hWndParent = NULL)
	int DoModalEx(HWND hWndParent = NULL)
	{
		m_bFromAutoUpdate = true;
		
		//m_tr = trSetting;
		m_bDeleteOnDestroy = false;
		
		InitMsgMap();
		int nRet = DoModal(hWndParent);
		
		return nRet;
	}	
	
	int Create(HWND hWndParent = NULL)
	{
		m_bFromAutoUpdate = false;
		
		m_bDeleteOnDestroy = true;
		
		InitMsgMap();
		//CPY 6/22/2006 MODELESS_DLG_NOT_REMEMBER_SIZE_POS
		// this is kept so dialog is responsible of remembering its size and location info
		DWORD dwDlgOptions = 0;//DLG_NO_DEFAULT_REPOSITION; 
		int nRet = Create(hWndParent, dwDlgOptions);
		Visible = true;
		
		return nRet;
	}

	bool GetGUI(TreeNode& trGUI);
	bool SetGUI(const TreeNode& trGUI);
	
	//void SetAutoUpdateMode(bool bAutoUpdate)
	//{
		//m_bFromAutoUpdate = bAutoUpdate;
	//}
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	///------ Folger 10/15/2010 ORG-1258 ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	ON_RESTORESIZE(OnRestoreSize)
	///------ End ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	ON_DESTROY(OnDestroy)
	
	ON_SYSCOMMAND(OnSystemCommand)
	//ON_GETMINMAXINFO(OnMinMaxInfo) 
	///---Sim 06-19-2009 QA80-13808 NOT_SWITCH_INPUT_WHEN_ACTIVE_SHEET_CHANGED
	//ON_CHANGE_LAYER(OnActiveLayerChange)
	///---END QA80-13808 NOT_SWITCH_INPUT_WHEN_ACTIVE_SHEET_CHANGED
	ON_OBJECT_MODIFY(OnOriginModify) ///---Sim 06-23-2009 QA81-13345 REFIX_UPDATE_ROW_SEL_AFTER_COL_VALUE_CHANGE
	
	ON_OK(OnClickOK)
	ON_CANCEL(OnClickCancel)
	
	ON_CONTEXTMENU(OnShowMenu)	
	ON_GRID_BEFORE_EDIT(IDC_COLUMN_LIST_GRID, OnBeforeEditColList)
	ON_GRID_BEFORE_EDIT(IDC_SEL_COLUMN_GRID, OnBeforeEditVarList)
	ON_GRID_AFTER_EDIT(IDC_COLUMN_LIST_GRID, OnAfterEditColList)
	ON_GRID_AFTER_EDIT(IDC_SEL_COLUMN_GRID, OnAfterEditVarList)
	ON_GRID_SEL_CHANGE(IDC_COLUMN_LIST_GRID, OnColListRowChange)	
	ON_GRID_SEL_CHANGE(IDC_SEL_COLUMN_GRID, OnVarListRowChange)	
	
	ON_MENU_CMD_RANGE(IDC_LOAD_CONDITION_SAMPLE_BEGIN, IDC_LOAD_CONDITION_SAMPLE_END, OnLoadSysSampleCondition)
	ON_MENU_CMD_RANGE(IDC_LOAD_CONDITION_BEGIN, IDC_LOAD_CONDITION_END, OnLoadUserDefinedCondition)
	ON_MENU_CMD_RANGE(IDC_RECENT_CONDITION_LIST_BEGIN, IDC_RECENT_CONDITION_LIST_END, OnLoadRecentUsedCondition)
	ON_MENU_CMD(IDC_SAVE_CONDITION, OnSaveCondition)
	ON_MENU_CMD(IDC_SAVE_CONDITION_AS, OnSaveConditionAs)
	ON_MENU_CMD(IDC_EDIT_SCRIPTS, OnEditScripts)	
	
	ON_MENU_CMD_RANGE(IDC_BASIC_FUNCTIONS_BEGIN, IDC_BASIC_FUNCTIONS_END, OnSelFunction)
	
	ON_BN_CLICKED(IDC_COL_HIDE_SHOW,OnClickHideColGridList)
	ON_BN_CLICKED(IDC_SELECT_BTN, OnClickSel)
	ON_BN_CLICKED(IDC_REMOVE_SELECT_BTN, OnClickRemoveSel)	
	
	ON_BN_CLICKED(IDC_ADD_BTN, OnClickAdd)
	ON_BN_CLICKED(IDC_REMOVE_BTN, OnClickRemove)
	
	ON_BN_CLICKED(IDC_APPLY_BTN, OnApply)
	ON_BN_CLICKED(IDC_TEST_BTN, OnClickTest)
	
	ON_BN_CLICKED(IDC_BTN_AND, OnClickAnd)
	ON_BN_CLICKED(IDC_BTN_OR, OnClickOr)
	ON_BN_CLICKED(IDC_BTN_NOT, OnClickNot)
	ON_BN_CLICKED(IDC_BTN_LEFT_P, OnClickLeftP)
	ON_BN_CLICKED(IDC_BTN_RIGHT_P, OnClickRightP)
	ON_BN_CLICKED(IDC_ALL_ROWS_BTN, OnClickAllRows) /// Iris 12/28/2008 ADD_SEL_ALL_ROWS_BUTTON
	
	///Jasmine 07/26/06 RECORD_CHANGE
	///---Sim 06-19-2009 QA80-4584 UPDATE_OK_AND_APPLY_BUTTON_STATUS_FOR_AUTO_UPDATE_SUPPORT
	ON_EN_CHANGE(IDC_EDIT_CONDITION, OnContentChange)
	ON_EN_CHANGE(IDC_ROW_FROM_ED, OnContentChange)
	ON_EN_CHANGE(IDC_ROW_TO_ED, OnContentChange)	
	///---END QA80-4584 UPDATE_OK_AND_APPLY_BUTTON_STATUS_FOR_AUTO_UPDATE_SUPPORT
	ON_EN_KILLFOCUS(IDC_ROW_FROM_ED, OnEDFromChange)//ON_EN_CHANGE(IDC_ROW_FROM_ED, OnContentChange)///Jasmine 08/11/06 MAKE_FROM_LESS_THAN_TO
	ON_EN_KILLFOCUS(IDC_ROW_TO_ED, OnEDToChange)//ON_EN_CHANGE(IDC_ROW_TO_ED, OnContentChange)	
	//ON_EN_CHANGE(IDC_ED_SPECIFIED_WKS, OnContentChange)
	//ON_EVENT(EN_SETFOCUS, IDC_ED_SPECIFIED_WKS, OnSpecifiedWksChange)
	//ON_EN_SETFOCUS(IDC_ED_SPECIFIED_WKS, OnSpecifiedWksChange)
	//ON_EN_KILLFOCUS(IDC_ED_SPECIFIED_WKS, OnSpecChange)	///Jasmine 08/25/06 BAD_FORMAT_WARNING
	
	//ON_BN_CLICKED(IDC_RADIO_TO_WKS, OnRadioChange)
	//ON_BN_CLICKED(IDC_RADIO_TO_WB, OnRadioChange)
	//ON_BN_CLICKED(IDC_RADIO_TO_SPEC, OnRadioChange)
	//ON_BN_CLICKED(IDC_RADIO_ADD_COL, OnRadioChange)
	///End RECORD_CHANGE
	
	///Folger 04/11/07 ADD_COLOR_SPECIFIER
	ON_GRID_DBLCLICK(IDC_COLUMN_LIST_GRID, OnDblClickToSel)
	//ON_GRID_DBLCLICK(IDC_SEL_COLUMN_GRID, OnDblClickToAdd)	///Jasmine 05/31/07 BLOCK_DBCLICK_BY_LARRY_REQUEST	
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	///End ADD_COLOR_SPECIFIER
	ON_HELPINFO(OnHelp)
	
EVENTS_END

	//------ fisher 11/15/07 ADD_MAP_ID_TO_CHM
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_XF_WEXTRACT;
		return true;
	}

	BOOL OnInitDialog();
	BOOL OnReady();
	BOOL OnDestroy();
	
	BOOL OnClickOK();
	BOOL OnClickCancel();
	
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny);
	
	enum{
		RESIZE_TYPE_SHOW_HIDE_LEFT_PANEL = 1,
	};
	BOOL OnDlgResize(int nType, int cx, int cy);
	
	///------ Folger 10/15/2010 ORG-1258 ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	BOOL OnRestoreSize(DWORD dwSizeInfo);
	///------ End ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	
	///---Sim 06-19-2009 QA80-13808 NOT_SWITCH_INPUT_WHEN_ACTIVE_SHEET_CHANGED
	//BOOL OnActiveLayerChange();
	///---END QA80-13808 NOT_SWITCH_INPUT_WHEN_ACTIVE_SHEET_CHANGED
	//bool GetWorksheet();	///Jasmine 08/08/06 ON_ACTIVE_LAYER_CHANGE
	BOOL OnOriginModify(OriginObject obj, int nKind); ///---Sim 06-23-2009 QA81-13345 REFIX_UPDATE_ROW_SEL_AFTER_COL_VALUE_CHANGE
	
	void OnBeforeEditColList(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	void OnBeforeEditVarList(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	void OnAfterEditColList(Control flxControl, int nRow, int nCol);
	void OnAfterEditVarList(Control flxControl, int nRow, int nCol);
	void OnColListRowChange(Control ctrl);
	void OnVarListRowChange(Control ctrl);

	BOOL OnLoadSysSampleCondition(int nID);
	BOOL OnLoadUserDefinedCondition(int nID);
	BOOL OnLoadRecentUsedCondition(int nID);
	BOOL OnSaveCondition();
	BOOL OnSaveConditionAs();
	BOOL OnEditScripts();
	
	BOOL OnSelFunction(int nID);
	
	BOOL OnClickHideColGridList(Control ctrl);
	BOOL OnClickSel(Control ctrl);
	BOOL OnClickRemoveSel(Control ctrl);
	BOOL OnClickAdd(Control ctrl);
	
	BOOL OnUndo(Control ctrl);
	BOOL OnApply(Control ctrl);
	BOOL OnClickTest(Control ctrl);
	
	BOOL OnClickRemove(Control ctrl);
	BOOL OnClickAnd(Control ctrl);
	BOOL OnClickOr(Control ctrl);
	BOOL OnClickNot(Control ctrl);	
	BOOL OnClickLeftP(Control ctrl);
	BOOL OnClickRightP(Control ctrl);
	
	BOOL OnClickAllRows(Control ctrl); /// Iris 12/28/2008 ADD_SEL_ALL_ROWS_BUTTON
	
	///Folger 04/11/07 ADD_COLOR_SPECIFIER
	BOOL OnDblClickToSel(Control ctrl);
	//BOOL OnDblClickToAdd(Control ctrl);
	///End ADD_COLOR_SPECIFIER
	
	///Jasmine 07/26/06 RECORD_CHANGE
	BOOL OnContentChange(Control ctrl); ///---Sim 06-19-2009 QA80-4584 UPDATE_OK_AND_APPLY_BUTTON_STATUS_FOR_AUTO_UPDATE_SUPPORT
	BOOL OnEDFromChange(Control ctrl);
	BOOL OnEDToChange(Control ctrl);
	//BOOL OnSpecifiedWksChange(Control ctrl);
	//BOOL OnSpecChange(Control ctrl);
	
	//BOOL OnRadioChange(Control ctrl);
	
	///Folger 04/11/07 ADD_COLOR_SPECIFIER
	void OnAfterValueChange(int nRow, DWORD lParam);
	///End ADD_COLOR_SPECIFIER
	
protected:
	bool Extract(const ExtractWksDataSettings *pSettings);
	
	//void MoveControls(const vector<int> ids, int nH = 0, int nV = 0);
	//void MoveRightControls(const vector<int> ids, int width, int height, int updown = 0) //updown = 0 up, updown = 1 down

	enum{
		DIR_LEFT,
		DIR_RIGHT,
	};
	BOOL ResizeColList(int nColWidthInc = 0,int nDirection = DIR_RIGHT);
	void ShowHideColList();
	void InflateWindow(int dx, int nDirection);
	int GetColListWidth();
	
	int CheckGetInvalidRowIndex(int nRowIndex, bool bFrom);	

	bool GetDlgSetting(TreeNode& tr, DWORD dwOptions = 0);
	bool SetDlgSetting(const TreeNode& tr, DWORD dwOptions = 0);
	
	bool GetDlgSetting(ExtractWksDataSettings *pSettings);
	bool SetDlgSetting(const ExtractWksDataSettings *pSettings);

	bool GetWksSetting(TreeNode& tr);
	bool SetWksSetting(const TreeNode& tr);	
	
	bool SetWorksheet(const Worksheet& wks);
	
	bool GetWksSettingToDlg();
	bool SetDlgToWksSetting();

	enum{
		FROM_SYS_MENU,
		FROM_USER_MENU,
		FROM_MRU_MENU,
	};
	bool LoadAndUpdateRecentUsedCondition(int nID, int nFromMenu);
	bool UpdateRecentUsedCondition(LPCSTR lpcszName, int nPathType = ORIGIN_PATH_USER);
	
private:
	void	initMenu();
	
	//void	enableCondition(bool bEnable = true);
	//void	enableApply(bool bEnable = true);
	//void	keepRange(int& nIndex, bool bTo = true)
	
	int		getColListMinWidth();
	int		getRevisedWidthForColListMinWidth();
	void	resizeAllRowsButton(int nGap = 5);
	void	updateSelRowNumber(string strNumber = "--");
	
	void	saveColListPos();
	void	loadColListPos();

	bool	updateDlgToColumnSetting(ExtractWksDataSettings *pSettings);
	bool	updateColumnSettingToDlg(const ExtractWksDataSettings *pSettings);
	bool	updateDlgToRowSetting(ExtractWksRowRange *pRowRange);
	bool	updateRowSettingToDlg(const ExtractWksRowRange *pRowRange);
	bool	updateDlgToAliasSetting(ExtractWksDataAlias *pAlias);
	bool	updateAliasSettingToDlg(const ExtractWksDataAlias *pAlias);
	bool	updateDlgToConditionSetting(ExtractWksDataCondition *pCondition);
	bool	updateConditionSettingToDlg(const ExtractWksDataCondition *pCondition);	
	///------ Folger 10/15/2010 ORG-1258 ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	//bool	updateDlgToMethodSetting(ExtractWksDataMethod *pMethod, int* pnAutoUpdateMode);
	//bool	updateMethodSettingToDlg(const ExtractWksDataMethod *pMethod, const int* pnAutoUpdateMode);
	bool	updateDlgToMethodSetting(ExtractWksDataMethod *pMethod, RecalculateSettings* pRecalculte);
	bool	updateMethodSettingToDlg(const ExtractWksDataMethod *pMethod, const RecalculateSettings* pRecalculte);
	///------ End ADD_SELECT_OPTION_IN_WORKSHEET_QUERY

	void	constructMethodGetN(TreeNode& tr);
	
	string	getConditionSetting(); 
	bool	setConditionSetting(LPCSTR lpcszCondition);
	
	//bool	loadCondition(LPCSTR lpcszName, LPCSTR lpcszFile = STR_FAVORITE_CONDITION_FILE);
	//bool	saveCondition(LPCSTR lpcszName, LPCSTR lpcszFile = STR_FAVORITE_CONDITION_FILE);
	bool	loadCondition(LPCSTR lpcszName, LPCSTR lpcszFile);
	bool	saveCondition(LPCSTR lpcszName, LPCSTR lpcszFile);

	///Kyle 02/22/2010 QA80-15100-P2 PASS_THE_CURRENT_COLUMN_DISPLAY_TO_TIME_LT_FUNCTION
	//string	getNewConditionLine(int nType = OKCOLTYPE_NUMERIC, LPCSTR lpcszAlias = NULL);
	string	getNewConditionLine(int nType = OKCOLTYPE_NUMERIC, int nSubFormat = 0, LPCSTR lpcszCustomDisp = NULL, LPCSTR lpcszAlias = NULL);
	///End PASS_THE_CURRENT_COLUMN_DISPLAY_TO_TIME_LT_FUNCTION
	
	void	insertStrToCondition(LPCSTR lpcsz, bool bFunctionStr = false);
	bool	checkVarInCondition(LPCSTR lpcszVar);
	
	bool	addAliasToDlg(int nColIndex, LPCSTR lpcszAliasName, vector<string> &vsInValid = NULL, vector<string> &vsRepeat = NULL, bool bAutoCorrect = false);	///Jasmine 11/26/09 AUTO_CORRECT_INVALID_ALIAS_WHEN_ADD_FROM_COLUMN_LIST
	void	showAliasWarning(const vector<string> &vsInValid = NULL, const vector<string> &vsRepeat = NULL, const vector<string> &vsMissing = NULL);
	
	/// Hong 02/10/09 RECALCULATE_SUPPORT
	//void	saveDlgSettingToTree();
	//void	loadTreeSettingToDlg(TreeNode& tr);
	
	//void	getExtractMethodTree(TreeNode& trExtractMethod, const ExtractWksDataMethod *pMethod);
	//void	setExtractMethodTree(ExtractWksDataMethod *pMethod, const TreeNode& trExtractMethod);

	
	/// end RECALCULATE_SUPPORT
	
	///---Sim 06-19-2009 QA80-4584 UPDATE_OK_AND_APPLY_BUTTON_STATUS_FOR_AUTO_UPDATE_SUPPORT
	void	notifySettingsUpdate(bool bDirty = true);
	///---END UPDATE_OK_AND_APPLY_BUTTON_STATUS_FOR_AUTO_UPDATE_SUPPORT

private:
	ExtractWksData	m_extwks;
	ExtractWksDataSettings	m_settings;

	ExtWksDataMenu* m_pDlgMenu;
	ColumnList		m_ColList;
	ColVarList 		m_VarList;
	//----- CPY 1/31/2008 QA70-11031 USE_EDIT_INSTEAD_OF_RICH_EDIT
	//RichEdit		m_edExpression; //==> strange bug for RichEdit, GetSel() broken
	Edit			m_edExpression; 
	//----- end USE_EDIT_INSTEAD_OF_RICH_EDIT
	
	Worksheet		m_wks;
	//string			m_strWks;
	Worksheet		m_wksTo;
	
	//vector<string>	m_vsRecConditions;
	//vector<uint>	m_vnRowIndices;	///Jasmine 08/18/06 KEEP_INDEX_TO_SAVE_TIME
	//Tree			m_trLastExtract;
	
	//string			m_strExpression;
	//string 			m_strBeforeLoop;
	//string			m_strBeforeIfCondition;
	string			m_strCurConditionName;
	
	//string			m_strNew;	///Jasmine 08/25/06 BLOCK_ACTIVATION_FROM_CODE
	// Sim, no need to do
	//string			m_strBlockNewWks;	///Jasmine 08/25/06 BLOCK_ACTIVATION_FROM_CODE
	//bool            m_bReady;
	
	bool            m_bShowColList;
	int             m_nLastColListWidth;
	
	DynaControl     m_DynaCntrlExtractMethod;			///Folger 04/11/07 ADD_COLOR_SPECIFIER
	Tree			m_trExtractMethod;

	/// Hong 02/10/09 RECALCULATE_SUPPORT
	bool			m_bDeleteOnDestroy;
	/// end RECALCULATE_SUPPORT

	bool			m_bFromAutoUpdate;
	//int				m_nAutoUpdateMode;///Sophy 8/7/2009 v8.1088 EXTRACT_WKS_DATA_SAVE_RECALCULATE_MODE_TO_SOURCE_SHEET don't need this value now
};

#endif // EXTRACT_WKS_DATA_DLG_H

